
// apple.h

#ifndef EMU6502_H
#define EMU6502_H 

typedef unsigned char boolean;
typedef unsigned char byte;
typedef unsigned short word;

struct T6502State
{
	byte A,X,Y,P,S;
	word PPC;
	int clock;
	byte *mem;
public:
	void tick(int amt) { clock += amt; }
	unsigned int getClock() { return clock; }
};

class T6502Emulation
{
protected:
	T6502State state;
	byte *mem;
public:
	T6502State* getState() { return &state; }
	byte *getMemory() { return mem; }
	void reset();
	void execute(int cycles);
	void setupBenchmark () ;
	virtual int readMemory(int address) = 0;
	virtual void writeMemory(int address, int value) = 0;
	virtual byte* getMemoryBase() = 0;
private:
//	void T6502Emulation::f_ADC(byte* mem, int& addr, byte& A, int& P);
//	void T6502Emulation::f_SBC(byte* mem, int& addr, byte& A, int& P);
};

#endif // APPLE_H
